#!/usr/bin/python3

from sys import argv, stdin
from re import match

INT = r'(0|([1-9][0-9]*))'

data = stdin.readlines()
assert len(data) > 0

assert match(rf'^{INT} {INT} {INT}\n$', data[0])
n, p, k = [ int(_) for _ in data[0].split() ]
assert 0 <= k
assert k <= p
assert p <= n
assert n <= 200000

data = data[1:]
assert len(data) == n

moves = []
for row in data:
    assert match(rf'^[VZ] {INT}\n$', row)
    s, d = row.split()
    d = int(d)
    assert 1 <= d
    assert d <= 10**9
    moves.append( (-1 if s=='Z' else +1) * d )

good_for_batch = 6 * [ False ]

good_for_batch[0] = True
good_for_batch[1] = k == 0
good_for_batch[2] = (n <= 1000 and p <= 10)
good_for_batch[3] = n <= 1000
good_for_batch[4] = n <= 70000
good_for_batch[5] = True

if len(argv) > 1:
    required_subtask = int( argv[1] )
    assert good_for_batch[required_subtask]

good_batches = ''.join( str(b) for b in range(1, len(good_for_batch)) if good_for_batch[b] )
print('OK', good_batches)

