#include <algorithm>
#include <cstdio>
#include <set>
using namespace std;

typedef long long ll;

int n, p, k;
int A[200'000];
multiset<int> low_k, top_k, middle;
ll sum = 0;
ll sum_low_k = 0, sum_top_k = 0;

void add(int value) {
  sum += value;
  if (value < 0) {
    low_k.insert(value);
    sum_low_k += value;
    if (low_k.size() > k) {
      auto it = std::prev(low_k.end());
      sum_low_k -= *it;
      middle.insert(*it);
      low_k.erase(it);
    }
  }
  if (value > 0) {
    top_k.insert(value);
    sum_top_k += value;
    if (top_k.size() > k) {
      auto it = top_k.begin();
      sum_top_k -= *it;
      middle.insert(*it);
      top_k.erase(it);
    }
  }
}

void remove(int value) {
  sum -= value;
  if (value < 0) {
    if (low_k.count(value) > 0) {
      low_k.erase(low_k.find(value));
      sum_low_k -= value;
      auto it = middle.begin();
      if (low_k.size() < k && middle.size() > 0 && *it < 0) {
        low_k.insert(*it);
        sum_low_k += *it;
        middle.erase(it);
      }
    } else {
      middle.erase(middle.find(value));
    }
  }
  if (value > 0) {
    if (top_k.count(value) > 0) {
      top_k.erase(top_k.find(value));
      sum_top_k -= value;
      if (middle.size() > 0) {
        auto it = std::prev(middle.end());
        if (top_k.size() < k && *it > 0) {
          top_k.insert(*it);
          sum_top_k += *it;
          middle.erase(it);
        }
      }
    } else {
      middle.erase(middle.find(value));
    }
  }
}

int main() {
  scanf("%d%d%d", &n, &p, &k);
  if (p == 0) {
    printf("0\n");
    return 0;
  }
  ll best = 0;
  char c;
  for (int i = 0; i < n; ++i) {
    scanf(" %c %d", &c, A + i);
    if (c == 'Z') A[i] = -A[i];
    add(A[i]);
    if (i >= p) {
      remove(A[i - p]);
    }
    if (i >= p - 1) {
      best = max(best, sum - 2 * sum_low_k);
      best = max(best, -sum + 2 * sum_top_k);
    }
    // printf("SUM %d %lld %lld\n", A[i], sum, best);
    // printf("  LOW %lld\n", sum_low_k);
    // printf("  TOP %lld\n", sum_top_k);
  }
  printf("%lld\n", best);
}
