#include <algorithm>
#include <cstdio>
using namespace std;

typedef long long ll;

const int MAXP = 10'000'001;
int n, p, k;
int C[20'000'047];
int A[200'000];
int low_k_id = 0, low_k_subid = 0, low_k_k = 0, neg = 0;
int top_k_id = MAXP * 2, top_k_subid = 0, top_k_k = 0, pos = 0;
ll sum = 0;
ll sum_low_k = 0, sum_top_k = 0;
ll steps = 0;

void fix_low_k() {
  while (low_k_k < neg && low_k_k < k) {    
    steps += 1;
    if (low_k_subid < C[low_k_id]) {
      low_k_subid += 1;
      low_k_k += 1;
      sum_low_k += low_k_id - MAXP;
      continue;
    }
    low_k_id += 1;
    low_k_subid = 0;
  }

  while (low_k_k > k) {
    if (low_k_subid > 0) {
      low_k_subid -= 1;
      low_k_k -= 1;
      sum_low_k -= low_k_id - MAXP;
      continue;
    }
    low_k_id -= 1;
    low_k_subid = C[low_k_id];
  }
}

void fix_top_k() {
  while (top_k_k < pos && top_k_k < k) {
    steps += 1;
    if (top_k_subid < C[top_k_id]) {
      top_k_subid += 1;
      top_k_k += 1;
      sum_top_k += top_k_id - MAXP;
      continue;
    }
    top_k_id -= 1;
    top_k_subid = 0;
  }

  while (top_k_k > k) {
    if (top_k_subid > 0) {
      top_k_subid -= 1;
      top_k_k -= 1;
      sum_top_k -= top_k_id - MAXP;
      continue;
    }
    top_k_id += 1;
    top_k_subid = C[top_k_id];
  }
}

void add(int value) {
  int v = value + MAXP;
  sum += value;
  C[v] += 1;
  if (value < 0) {
    neg += 1;
    if (v < low_k_id) {
      low_k_k += 1;
      sum_low_k += value;
    }
    fix_low_k();
  }
  if (value > 0) {
    pos += 1;
    if (v > top_k_id) {
      top_k_k += 1;
      sum_top_k += value;
    }
    fix_top_k();
  }
}

void remove(int value) {
  int v = value + MAXP;
  sum -= value;
  C[v] -= 1;
  if (value < 0) {
    neg -= 1;
    if (v < low_k_id) {
      low_k_k -= 1;
      sum_low_k -= value;
    }
    if (v == low_k_id) {
      low_k_k -= 1;
      low_k_subid -= 1;
      sum_low_k -= value;
    }
    fix_low_k();
  }
  if (value > 0) {
    pos -= 1;
    if (v > top_k_id) {
      top_k_k -= 1;
      sum_top_k -= value;
    }
    if (v == top_k_id) {
      top_k_k -= 1;
      top_k_subid -= 1;
      sum_top_k -= value;
    }
    fix_top_k();
  }
}

int main() {
  scanf("%d%d%d", &n, &p, &k);
  if (p == 0) {
    printf("0\n");
    return 0;
  }
  ll best = 0;
  char c;
  for (int i = 0; i < n; ++i) {
    scanf(" %c %d", &c, A + i);
    if (A[i] > MAXP) return 0;
    if (c == 'Z') A[i] = -A[i];
    add(A[i]);
    if (i >= p) {
      remove(A[i - p]);
    }
    if (i >= p - 1) {
      best = max(best, sum - 2 * sum_low_k);
      best = max(best, -sum + 2 * sum_top_k);
    }
    // printf("SUM %d %lld %lld\n", A[i], sum, best);
    // printf("  LOW %d %d %d %d %lld\n", low_k_id, low_k_subid, low_k_k, neg,
    //        sum_low_k);
    // printf("  TOP %d %d %d %d %lld\n", top_k_id, top_k_subid, top_k_k, pos,
    //        sum_top_k);
  }
  // fprintf(stderr, "%lld\n", steps);
  printf("%lld\n", best);
}
