#include <algorithm>
#include <cstdio>
#include <map>
#include <set>
#include <vector>
using namespace std;

typedef long long ll;

set<int> values;
map<int, int> v_to_c;
vector<int> c_to_v;

int MAXP = 200'001;
int n, p, k;
vector<int> C;
int A[200'000];
int low_k_id = 0, low_k_subid = 0, low_k_k = 0, neg = 0;
int top_k_id = MAXP * 2, top_k_subid = 0, top_k_k = 0, pos = 0;
ll sum = 0;
ll sum_low_k = 0, sum_top_k = 0;
ll steps = 0;

void fix_low_k() {
  while (low_k_k < neg && low_k_k < k) {
    steps += 1;
    if (low_k_subid < C[low_k_id]) {
      low_k_subid += 1;
      low_k_k += 1;
      sum_low_k += -c_to_v[-low_k_id + MAXP];
      continue;
    }
    low_k_id += 1;
    low_k_subid = 0;
  }

  while (low_k_k > k) {
    if (low_k_subid > 0) {
      low_k_subid -= 1;
      low_k_k -= 1;
      sum_low_k -= -c_to_v[-low_k_id + MAXP];
      continue;
    }
    low_k_id -= 1;
    low_k_subid = C[low_k_id];
  }
}

void fix_top_k() {
  while (top_k_k < pos && top_k_k < k) {
    steps += 1;
    if (top_k_subid < C[top_k_id]) {
      top_k_subid += 1;
      top_k_k += 1;
      sum_top_k += c_to_v[top_k_id - MAXP];
      continue;
    }
    top_k_id -= 1;
    top_k_subid = 0;
  }

  while (top_k_k > k) {
    if (top_k_subid > 0) {
      top_k_subid -= 1;
      top_k_k -= 1;
      sum_top_k -= c_to_v[top_k_id - MAXP];
      continue;
    }
    top_k_id += 1;
    top_k_subid = C[top_k_id];
  }
}

void add(int value) {
  int v = v_to_c[value] + MAXP;
  sum += value;
  C[v] += 1;
  if (value < 0) {
    neg += 1;
    if (v < low_k_id) {
      low_k_k += 1;
      sum_low_k += value;
    }
    fix_low_k();
  }
  if (value > 0) {
    pos += 1;
    if (v > top_k_id) {
      top_k_k += 1;
      sum_top_k += value;
    }
    fix_top_k();
  }
}

void remove(int value) {
  int v = v_to_c[value] + MAXP;
  sum -= value;
  C[v] -= 1;
  if (value < 0) {
    neg -= 1;
    if (v < low_k_id) {
      low_k_k -= 1;
      sum_low_k -= value;
    }
    if (v == low_k_id) {
      low_k_k -= 1;
      low_k_subid -= 1;
      sum_low_k -= value;
    }
    fix_low_k();
  }
  if (value > 0) {
    pos -= 1;
    if (v > top_k_id) {
      top_k_k -= 1;
      sum_top_k -= value;
    }
    if (v == top_k_id) {
      top_k_k -= 1;
      top_k_subid -= 1;
      sum_top_k -= value;
    }
    fix_top_k();
  }
}

int main() {
  scanf("%d%d%d", &n, &p, &k);
  if (p == 0) {
    printf("0\n");
    return 0;
  }
  ll best = 0;
  char c;
  values.insert(0);
  for (int i = 0; i < n; ++i) {
    scanf(" %c %d", &c, A + i);
    values.insert(A[i]);
    if (c == 'Z') A[i] = -A[i];
  }
  int idx = 0;
  c_to_v.resize(values.size());
  for (auto v : values) {
    v_to_c[v] = idx;
    v_to_c[-v] = -idx;
    c_to_v[idx] = v;
    ++idx;
  }
  MAXP = idx + 1;
  C = vector<int>(MAXP * 2 + 1, 0);
  top_k_id = MAXP * 2;
  //fprintf(stderr, "%d\n", MAXP);

  for (int i = 0; i < n; ++i) {
    add(A[i]);
    if (i >= p) {
      remove(A[i - p]);
    }
    if (i >= p - 1) {
      best = max(best, sum - 2 * sum_low_k);
      best = max(best, -sum + 2 * sum_top_k);
    }
    // printf("SUM %d %lld %lld\n", A[i], sum, best);
    // printf("  LOW %d %d %d %d %lld\n", low_k_id, low_k_subid, low_k_k, neg,
    //        sum_low_k);
    // printf("  TOP %d %d %d %d %lld\n", top_k_id, top_k_subid, top_k_k, pos,
    //        sum_top_k);
  }
  // fprintf(stderr, "%lld\n", steps);
  printf("%lld\n", best);
}
