#include <algorithm>
#include <cstdio>
using namespace std;

typedef long long ll;

const int MAXP = 1'000'001;
int n, p, k;
int C[2'000'047];
int A[200'000];
ll sum = 0;
ll sum_low_k = 0, sum_top_k = 0;
ll steps = 0;
ll change_low = 0, change_high = 0;

void fix_low_k() {
  change_low = 0;
  sum_low_k = 0;
  int i, cnt = 0;
  for (i = 0; i < MAXP && cnt < k; ++i) {
    cnt += C[i];
    sum_low_k += (i - MAXP) * ll(C[i]);
  }
  if (cnt > k) {
    sum_low_k -= (i - 1 - MAXP) * ll(cnt - k);
  }
}

void fix_top_k() {
  change_high = 0;
  sum_top_k = 0;
  int i, cnt = 0;
  for (i = 2 * MAXP; i > MAXP && cnt < k; --i) {
    cnt += C[i];
    sum_top_k += (i - MAXP) * ll(C[i]);
  }
  if (cnt > k) {
    sum_top_k -= (i + 1 - MAXP) * ll(cnt - k);
  }
}

void add(int value) {
  sum += value;
  C[value + MAXP] += 1;
  if (value < 0) change_low = 1;
  if (value > 0) change_high = 1;
}

void remove(int value) {
  sum -= value;
  C[value + MAXP] -= 1;
  if (value < 0) change_low = 1;
  if (value > 0) change_high = 1;
}

int main() {
  scanf("%d%d%d", &n, &p, &k);
  if (p == 0) {
    printf("0\n");
    return 0;
  }
  ll best = 0;
  char c;
  for (int i = 0; i < n; ++i) {
    scanf(" %c %d", &c, A + i);
    if (A[i] > MAXP) return 0;
    if (c == 'Z') A[i] = -A[i];
    add(A[i]);
    if (i >= p) {
      remove(A[i - p]);
    }
    if (i >= p - 1) {
      if (change_low) fix_low_k();
      if (change_high) fix_top_k();
      best = max(best, sum - 2 * sum_low_k);
      best = max(best, -sum + 2 * sum_top_k);
    }
  }
  printf("%lld\n", best);
}
