# ============================ Naive implementation of sorted list ==============================

class SortedList:
    def __init__(self, values: list):
        self.data = values
        self.data.sort()
        self.sum = sum(self.data)
        self.positives = sum(1 for num in self.data if num > 0)

    def add(self, value: int):
        self.sum += value
        if value > 0: 
            self.positives += 1
        for i, num in enumerate(self.data):
            if num >= value:
                self.data.insert(i, value)
                return
        self.data.append(value)

    def remove(self, value: int):
        self.sum -= value
        if value > 0: 
            self.positives -= 1
        self.data.remove(value)

    def sum_smallest_k_negatives(self) -> int: 
        k_negatives = min(K, len(self.data) - self.positives)
        return sum(self.data[:k_negatives])

    def sum_largest_k_positives(self) -> int: 
        k_positives = min(K, self.positives)
        return sum(self.data[len(self.data)-k_positives:])


N, P, K = [ int(_) for _ in input().split() ]
D = []
for n in range(N):
    smer, vzd = input().split()
    D.append(int(vzd) if smer=='V' else -int(vzd))

S = SortedList(D[:P])
best = max(S.sum - 2*S.sum_smallest_k_negatives(), -S.sum + 2*S.sum_largest_k_positives())
for i in range(N-P):
    S.add(D[i+P])
    S.remove(D[i])
    best_now = max(S.sum - 2*S.sum_smallest_k_negatives(), -S.sum + 2*S.sum_largest_k_positives())
    best = max(best, best_now)
print(best)
