#!/usr/bin/python3

from random import seed, randint, choice

PERTURBATIONS = 20
id, N, P, K, type, MAX_D = input().split()
id, N, P, K, MAX_D = map(int, (id, N, P, K, float(MAX_D)))
MIN_D = -MAX_D
seed(id)

if type == "random":
    A = [randint(MIN_D, MAX_D) for i in range(N)]

elif type.startswith("sorted"):
    A = [randint(MIN_D, MAX_D) for i in range(N)]
    A.sort()
    if type == "sorted2":
        A.reverse()
    if type == "sorted3":
        for i in range(N):
            if randint(0, 2) == 0: A[i] *= -1
    if type == "sorted4":
        A = [randint(MIN_D, MAX_D) for i in range(N)]
        B, C = A[:N//2], A[N//2:]
        B.sort(key=lambda x: abs(x))
        C.sort(key=lambda x: -abs(x))
        A = B + C
    for i in range(PERTURBATIONS):
        A[randint(0, len(A)-1)] = A[randint(0, len(A)-1)]
    for i in range(PERTURBATIONS):
        A[i] = randint(MIN_D, MAX_D)
        A[-i] = randint(MIN_D, MAX_D)

elif type == "zig_zag":
    direction = "up"
    value = 0
    A = []
    for i in range(N):
        if direction == "up":
            value = min(MAX_D, value + randint(0, 10))
        else:
            value = max(0, value - randint(0, 10))
        if randint(0, int(N**0.5)) == 0 or value == MAX_D or value == 0:
            direction = ("up", "down")[randint(0, 1)]
        
        A.append(value if randint(0, 2) else -value)

elif type == "copies":
    A = [randint(MIN_D, MAX_D) for i in range(N)]
    # A[1:4] and also number 0 will appear many times, and roughly 1/4 elements will be truly random
    for i in range(5, N):
        clone = randint(0, 4)
        if clone:
            A[i] = A[clone] * randint(-1, 1)

elif type.startswith("jumpy"):
    values = [MIN_D, MIN_D//2, -1, 0, 1, MAX_D//2, MAX_D]
    if type == "jumpy_positive":
        values = [1, MAX_D]
    A = [( choice(values) if randint(0, 10) else randint(MIN_D, MAX_D)) 
         for i in range(N)]   
        
else:
    raise ValueError(f"Unexpected type {type}")

assert(len(A) == N)
assert(N >= P >= K)

print(N, P, K)
for a in A:
    if a == 0:
        a = -1 if randint(0,1) else +1
    if a > 0:
        print(f"V {abs(a)}")
    else:
        print(f"Z {abs(a)}")

