from sys import argv, stdin
from re import match

INT = r'(0|([1-9][0-9]*))'

class Hrana:
    def __init__(self, **kwargs):
        for key, value in kwargs.items():
            setattr(self, key, value)

data = stdin.readlines()
assert len(data) > 0

assert match(rf'^{INT} {INT}\n$', data[0])
n, m = [ int(_) for _ in data[0].split() ]
assert 2 <= n <= 100000
assert 0 <= m <= 200000
assert len(data) == 1+m

edges = []
for line in data[1:]:
    assert match(rf'^{INT} {INT} {INT} {INT} {INT} [ZC] {INT}\n', line)
    tokens = line.split()
    start, ciel, dlzka, zelena, cervena = [ int(_) for _ in tokens[:5] ]
    assert 1 <= start <= n
    assert 1 <= ciel <= n
    assert start != ciel
    assert 1 <= dlzka <= 10**9
    assert 1 <= zelena <= 10**9
    assert 0 <= cervena <= 10**9
    farba, ostane = tokens[5], int(tokens[6])
    if farba == 'Z':
        assert 1 <= ostane <= zelena
        offset = zelena - ostane
    else:
        assert 1 <= ostane <= cervena
        offset = zelena + cervena - ostane
    edges.append( Hrana( start=start, ciel=ciel, dlzka=dlzka, zelena=zelena, cervena=cervena, offset=offset ) )

good_for_batch = 7 * [ True ]

if not all( h.zelena == 1 for h in edges ): good_for_batch[1] = False
if not all( h.cervena == 1 for h in edges ): good_for_batch[1] = False
if not all( h.dlzka <= 10 for h in edges ): good_for_batch[1] = False

if not all( h.zelena + h.cervena == 1000 for h in edges ): good_for_batch[2] = False
if not (m <= 5000): good_for_batch[2] = False
if not all( h.dlzka == 1 for h in edges ): good_for_batch[2] = False

if not all( h.zelena + h.cervena <= 8 for h in edges ): good_for_batch[3] = False
if not (m <= 5000): good_for_batch[3] = False
if not all( h.dlzka == 1 for h in edges ): good_for_batch[3] = False

if not all( h.cervena == 0 for h in edges ): good_for_batch[4] = False

if not len(set(h.zelena for h in edges)) == 1: good_for_batch[5] = False
if not len(set(h.cervena for h in edges)) == 1: good_for_batch[5] = False
if not all(h.offset == 0 for h in edges): good_for_batch[5] = False

if len(argv) > 1:
    required_subtask = int( argv[1] )
    assert good_for_batch[required_subtask]

good_batches = ''.join( str(b) for b in range(1, len(good_for_batch)) if good_for_batch[b] )
print('OK', good_batches)

