from heapq import heappush, heappop

class Hrana:
    def __init__(self, **kwargs):
        for key, value in kwargs.items():
            setattr(self, key, value)

    def cas_v_cieli(self, cas_na_starte):
        zvysok = (cas_na_starte + self.offset) % (self.zelena + self.cervena)
        if zvysok < self.zelena:
            return cas_na_starte + self.dlzka
        else:
            return cas_na_starte - zvysok + self.zelena + self.cervena + self.dlzka

n, m = [ int(_) for _ in input().split() ]
G = [ [] for _ in range(n) ]
for mm in range(m):
    tokens = input().split()
    start, ciel, dlzka, zelena, cervena = [ int(_) for _ in tokens[:5] ]
    start, ciel = start-1, ciel-1
    if tokens[5] == 'Z':
        offset = zelena - int(tokens[6])
    else:
        offset = zelena + cervena - int(tokens[6])
    G[start].append( Hrana( ciel=ciel, dlzka=dlzka, zelena=zelena, cervena=cervena, offset=offset ) )

dist = [ 10**18 for _ in range(n) ]
dist[0] = 0
Q = []
heappush( Q, (0,0) )

while len(Q) > 0:
    d, kde = heappop(Q)
    if dist[kde] < d: continue
    for hrana in G[kde]:
        kam, kedy = hrana.ciel, hrana.cas_v_cieli(d)
        if kedy < dist[kam]:
            dist[kam] = kedy
            heappush( Q, (kedy,kam) )

if dist[n-1] == 10**18:
    print(-1)
else:
    print(dist[n-1])

