#include <cassert>
#include <iostream>
#include <limits>
#include <queue>
using namespace std;

struct Semafor {
  int z, c;
  int startFaza;

  int perioda() const { return z + c; }

  int faza(long long t) const { return int((t + startFaza) % perioda()); }

  int casDoZelenej(long long t) const {
    int f = faza(t);
    if (f < z) {
      return 0;
    } else {
      return z + c - f;
    }
  }

  void nacitaj() {
    cin >> z >> c;
    string start;
    int f;
    cin >> start >> f;
    if (start == "Z") {
      startFaza = z - f;
    } else if (start == "C") {
      startFaza = z + c - f;
    } else {
      assert(false && "Pociatocny stav semaforu musi byt Z alebo C");
    }
  }
};

struct Cesta {
  int a, b;
  int dt;
  Semafor semafor;

  void nacitaj() {
    cin >> a >> b >> dt;
    a--;
    b--;
    semafor.nacitaj();
  }

  int casNaPrejdenieVCase(long long t) const {
    return dt + semafor.casDoZelenej(t);
  }
};

int main() {
  int n, m;
  cin >> n >> m;
  vector<vector<Cesta>> cesty;
  cesty.resize(n);
  for (int mi = 0; mi < m; mi++) {
    Cesta c;
    c.nacitaj();
    cesty[c.a].push_back(c);
  }

  struct Trasa {
    int vrchol;
    long long t;

    // cim vacsi cas, tym mensia priorita
    bool operator<(const Trasa& x) const { return t > x.t; }

    Trasa potom(const Cesta& c) const {
      return {c.b, t + c.casNaPrejdenieVCase(t)};
    }
  };

  vector<long long> minCasPrichodu;
  minCasPrichodu.resize(n, numeric_limits<long long>::max());

  priority_queue<Trasa> pq;
  pq.push({0, 0});
  minCasPrichodu[0] = 0;
  while (!pq.empty()) {
    const Trasa trasa = pq.top();
    pq.pop();

    if (trasa.t != minCasPrichodu[trasa.vrchol]) {
      continue;
    }
    minCasPrichodu[trasa.vrchol] = trasa.t;

    if (trasa.vrchol == n - 1) {
      break;
    }

    for (const auto& cesta : cesty[trasa.vrchol]) {
      const Trasa kandidat = trasa.potom(cesta);
      if (minCasPrichodu[kandidat.vrchol] <= kandidat.t) {
        continue;
      }
      minCasPrichodu[kandidat.vrchol] = kandidat.t;
      pq.push(kandidat);
    }
  }

  long long vysl = minCasPrichodu[n - 1];
  cout << (vysl == numeric_limits<long long>::max() ? -1 : vysl) << "\n";
  return 0;
}